/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableWithSize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsIterableWithSizeTest
extends AbstractMatcherTest {
    @Override
    protected Matcher<?> createMatcher() {
        return IsIterableWithSize.iterableWithSize((int)7);
    }

    public void testMatchesEmptyIterable() throws Exception {
        IsIterableWithSizeTest.assertMatches("Empty iterable", IsIterableWithSize.iterableWithSize((int)0), Collections.emptyList());
    }

    public void testMatchingSingleItemIterable() throws Exception {
        IsIterableWithSizeTest.assertMatches("Single item iterable", IsIterableWithSize.iterableWithSize((int)1), Arrays.asList(1));
    }

    public void testMatchingMultipleItemIterable() throws Exception {
        IsIterableWithSizeTest.assertMatches("Multiple item iterable", IsIterableWithSize.iterableWithSize((int)3), Arrays.asList(1, 2, 3));
    }

    public void testDoesNotMatchIncorrectSize() throws Exception {
        IsIterableWithSizeTest.assertDoesNotMatch("Incorrect size", IsIterableWithSize.iterableWithSize((int)3), Arrays.asList(1));
    }

    public void testHasAReadableDescription() {
        IsIterableWithSizeTest.assertDescription("an iterable with size <4>", IsIterableWithSize.iterableWithSize((int)4));
    }
}

